// BullsEyePropPage.h : Deklaracja CBullsEyePropPage

#ifndef __BULLSEYEPROPPAGE_H_
#define __BULLSEYEPROPPAGE_H_

#include "resource.h"       // gwne symbole
#include <commctrl.h>

EXTERN_C const CLSID CLSID_BullsEyePropPage;

/////////////////////////////////////////////////////////////////////////////
// CBullsEyePropPage
class ATL_NO_VTABLE CBullsEyePropPage :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CBullsEyePropPage, &CLSID_BullsEyePropPage>,
	public IPropertyPage2Impl<CBullsEyePropPage>,
	public CDialogImpl<CBullsEyePropPage>,
    public IPropertyNotifySink
{
public:
	CBullsEyePropPage() 
	{
		m_dwTitleID     = IDS_TITLEBullsEyePropPage;
		m_dwHelpFileID  = IDS_HELPFILEBullsEyePropPage;
		m_dwDocStringID = IDS_DOCSTRINGBullsEyePropPage;

        m_flags         = 0;    // Jak na razie brak zmian
        m_pCookies      = NULL;
        m_EditProperty  = DISPID_UNKNOWN;
	}

	~CBullsEyePropPage()
    {
    }

	enum {IDD = IDD_BULLSEYEPROPPAGE};

DECLARE_REGISTRY_RESOURCEID(IDR_BULLSEYEPROPPAGE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CBullsEyePropPage) 
	COM_INTERFACE_ENTRY(IPropertyPage)
	COM_INTERFACE_ENTRY_IMPL(IPropertyPage2)
	COM_INTERFACE_ENTRY(IPropertyNotifySink)
END_COM_MAP()

BEGIN_MSG_MAP(CBullsEyePropPage)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	COMMAND_HANDLER(IDC_BEEP, BN_CLICKED, OnClickedBeep)
	COMMAND_HANDLER(IDC_RINGCOUNT, EN_CHANGE, OnChangeRingCount)
	COMMAND_HANDLER(IDC_ENABLED, BN_CLICKED, OnClickedEnabled)
	COMMAND_HANDLER(IDC_TRANSPARENT, BN_CLICKED, OnClickedTransparent)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	CHAIN_MSG_MAP(IPropertyPageImpl<CBullsEyePropPage>)
END_MSG_MAP()
// Prototypy procedur obsugi:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

// IPropertyPage2
	STDMETHODIMP Activate(HWND hWndParent, LPCRECT pRect, BOOL /* bModal */);
	STDMETHODIMP Apply(void);
    STDMETHODIMP EditProperty(DISPID dispID);
    STDMETHODIMP SetObjects(ULONG nObjects, IUnknown** ppUnk);

// IPropertyNotifySink
    STDMETHODIMP OnChanged(DISPID dispid);
    STDMETHODIMP OnRequestEdit(DISPID dispid);

// Procedury obsugi wiadomoci okna dialogowego
	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnClickedBeep(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedEnabled(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnChangeRingCount(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedTransparent(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);

private:
	DISPID m_EditProperty;
    enum {BEEP_CHANGED = 1, RINGCOUNT_CHANGED = 2, ENABLED_CHANGED = 4, TRANSPARENT_CHANGED = 8};

	short                       m_flags;            // Zmiana znacznikw
	VARIANT_BOOL                m_beepOrig;         // Dwik po trafieniu piercienia?
	VARIANT_BOOL                m_beepNew;          // Dwik po trafieniu piercienia?
	VARIANT_BOOL                m_enabledOrig;      // Wczony element sterujcy?
	VARIANT_BOOL                m_enabledNew;       // Wczony element sterujcy?
	long                        m_transparentOrig;  // Waciwo BackStyle
	long                        m_transparentNew;   // Waciwo BackStyle
    short                       m_ringCountOrig;    // Liczba piercieni
    short                       m_ringCountNew;     // Liczba piercieni

	LPDWORD m_pCookies;    // Tablica etonw poczenia uywana przez
                           // IConnectionPoint::Advise/Unadvise.

protected:
	void InitializeControlsFromObject(DISPID dispid);
    void SetPropertiesFromControls(DISPID dispid);
	void CleanupObjectArray();
};

#endif //__BULLSEYEPROPPAGE_H_
